/*
 * Decompiled with CFR 0.152.
 */
public class TemperatureParameters {
    public double maxTemp;
    public double minTemp;
    public double thermalDiff;
    public double depth;
    public double dampingDepth;
    public double phaseConst;
    public double amplitude;
    public double avgTemp;
    public int timeLag;
    public int month;
    public int day;
    public int dayOfInterest;

    public TemperatureParameters() {
        this.dayOfInterest = -1;
    }

    public TemperatureParameters(double d, double d2, double d3, int n, double d4, int n2, int n3) {
        this.maxTemp = d;
        this.minTemp = d2;
        this.thermalDiff = d3;
        this.timeLag = n;
        this.depth = d4;
        this.month = n2;
        this.day = n3;
        this.amplitude = (this.maxTemp - this.minTemp) / 2.0;
        this.avgTemp = (this.maxTemp + this.minTemp) / 2.0;
        this.dampingDepth = this.DampDepth();
        this.phaseConst = this.PhaseConst();
        this.dayOfInterest = this.DateCalc();
    }

    private double PhaseConst() {
        return 1.5707963267948966 + 0.01721420632103996 * (double)this.timeLag;
    }

    private double DampDepth() {
        return Math.sqrt(2.0 * this.thermalDiff / 0.01721420632103996);
    }

    private int DateCalc() {
        int n = 0;
        for (int i = 0; i < this.month; ++i) {
            n += Util.daysInMonth[i];
        }
        return n + this.day;
    }
}

