/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.jnlp.PrintService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class SoilTemperature {
    private static final int MAXPOINTS = 50;
    private static final int MAXLINES = 5;
    static Color currentColor = new Color(225, 225, 225);
    static JPanel labelPanel;
    static JPanel labelPanel2;
    static JPanel messagePanel;
    static JPanel textSbrPanel;
    static JPanel textSbrPanel2;
    static JPanel upLeftPanel;
    static JPanel upRightPanel;
    static JPanel mainPanel;
    static JPanel northPanel;
    static JPanel topPanel;
    static JPanel graphPanel;
    static JPanel middlePanel;
    static JPanel buttonPanel;
    static JButton bSave;
    static JButton bClear;
    static boolean celsiusUnits;
    static String message1;
    static JLabel lMessage1;
    private static ButtonGroup buttonGroupMenu;
    static double maxTemp;
    static double minTemp;
    static double maxTempF;
    static double minTempF;
    static double thermalDif;
    static int timeLag;
    static double depth;
    static int month2;
    static int date2;
    static int jLines;
    static int maxpoints;
    static JLabel lMessage;
    private static final Color[] colorLine;
    static TemperatureParameters[] params;

    public static void main(String[] stringArray) {
        new forPrinting();
    }

    public static void updateMessage() {
        message1 = new String(" ");
        lMessage.setText(message1);
        lMessage.setVisible(true);
    }

    static {
        celsiusUnits = true;
        buttonGroupMenu = new ButtonGroup();
        maxTemp = 30.0;
        minTemp = 0.0;
        maxTempF = 32.0 + maxTemp * 9.0 / 5.0;
        minTempF = 32.0 + minTemp * 9.0 / 5.0;
        thermalDif = 0.07;
        timeLag = 10;
        depth = 0.0;
        month2 = 0;
        date2 = 1;
        jLines = 0;
        maxpoints = 50;
        colorLine = new Color[]{Color.red, Color.darkGray, Color.green, Color.magenta, Color.blue};
        params = new TemperatureParameters[5];
    }

    static class Temperature
    extends JPanel
    implements Printable {
        double xmax2 = 0.0;
        double xmin2 = 0.0;
        double ymax2 = 0.0;
        double ymin2 = 0.0;
        JComboBox month;
        JComboBox date;
        JLabel lMaxTemp = new JLabel("Max Temperature (\u00b0C) ");
        JLabel lMinTemp = new JLabel("Min Temperature (\u00b0C) ");
        JLabel lMaxTempF = new JLabel("Max Temperature (\u00b0F) ");
        JLabel lMinTempF = new JLabel("Min Temperature (\u00b0F) ");
        JLabel lThermalDif = new JLabel("    Thermal Diffusivity (m  /day)");
        JLabel lThermalDif2 = new JLabel("2");
        JLabel lTimeLag = new JLabel("    Time Lag (days)");
        JLabel lDepth = new JLabel("Graph of Temperature vs. Time ");
        JLabel lDepth2 = new JLabel("  at Depth (meters) ");
        JLabel lTime = new JLabel("Graph of Temperature vs. Depth ");
        JLabel lTime2 = new JLabel("             at Time (month/day)");
        JTextField tfMaxTemp = new JTextField(Tools.formatDouble(maxTemp, 1, 1), 4);
        JTextField tfMinTemp = new JTextField(Tools.formatDouble(minTemp, 1, 1), 4);
        JTextField tfMaxTempF = new JTextField(Tools.formatDouble(maxTempF, 1, 1), 4);
        JTextField tfMinTempF = new JTextField(Tools.formatDouble(minTempF, 1, 1), 4);
        JTextField tfThermalDif = new JTextField(Tools.formatDouble(thermalDif, 4, 1), 4);
        JTextField tfTimeLag = new JTextField(Tools.formatDouble(timeLag, 0, 1), 4);
        JTextField tfDepth = new JTextField(Tools.formatDouble(depth, 2, 1), 4);
        JScrollBar sbrMaxTemp = new JScrollBar(0, (int)(maxTemp * 10.0), 1, 50, 501);
        JScrollBar sbrMinTemp = new JScrollBar(0, (int)(minTemp * 10.0), 1, -300, 401);
        JScrollBar sbrMaxTempF = new JScrollBar(0, (int)(maxTempF * 10.0), 1, 410, 1221);
        JScrollBar sbrMinTempF = new JScrollBar(0, (int)(minTempF * 10.0), 1, -220, 1041);
        JScrollBar sbrThermalDif = new JScrollBar(0, (int)(thermalDif * 1000.0), 1, 1, 501);
        JScrollBar sbrTimeLag = new JScrollBar(0, timeLag, 1, 0, 366);
        JScrollBar sbrDepth = new JScrollBar(0, (int)(depth * 100.0), 1, 0, 2001);
        FontMetrics fm;
        TemperatureParameters[] params = new TemperatureParameters[5];
        double[] x = new double[51];
        double[] y = new double[51];
        double[] tVt = new double[51];
        double[] tVd = new double[51];
        double[] tVtF = new double[51];
        double[] tVdF = new double[51];
        int j;
        Border etched = BorderFactory.createEtchedBorder();
        int gW = 300;
        int gH = 255;

        public Temperature() {
            for (int i = 0; i < 5; ++i) {
                this.params[i] = new TemperatureParameters();
            }
            this.params[0] = new TemperatureParameters(maxTemp, minTemp, thermalDif, timeLag, depth, month2, date2);
            String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
            this.month = new JComboBox<String>(stringArray);
            this.month.setSelectedIndex(0);
            String[] stringArray2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
            this.date = new JComboBox<String>(stringArray2);
            this.date.setSelectedIndex(0);
            lMessage = new JLabel("", 0);
            labelPanel = new JPanel();
            labelPanel.setLayout(new GridLayout(2, 1));
            labelPanel.setBackground(currentColor);
            if (celsiusUnits) {
                labelPanel.add(this.lMaxTemp);
                this.lMaxTemp.setForeground(Color.blue);
                this.lMaxTemp.setFont(new Font("Serif", 0, 14));
                labelPanel.add(this.lMinTemp);
                this.lMinTemp.setForeground(Color.blue);
                this.lMinTemp.setFont(new Font("Serif", 0, 14));
            } else {
                labelPanel.add(this.lMaxTempF);
                this.lMaxTempF.setForeground(Color.blue);
                this.lMaxTempF.setFont(new Font("Serif", 0, 14));
                labelPanel.add(this.lMinTempF);
                this.lMinTempF.setForeground(Color.blue);
                this.lMinTempF.setFont(new Font("Serif", 0, 14));
            }
            textSbrPanel = new JPanel();
            textSbrPanel.setLayout(new GridLayout(2, 2, 5, 0));
            textSbrPanel.setBackground(currentColor);
            if (celsiusUnits) {
                textSbrPanel.add(this.tfMaxTemp);
                textSbrPanel.add(this.sbrMaxTemp);
                this.sbrMaxTemp.setUnitIncrement(10);
                this.sbrMaxTemp.setBackground(new Color(225, 225, 225));
                textSbrPanel.add(this.tfMinTemp);
                textSbrPanel.add(this.sbrMinTemp);
                this.sbrMinTemp.setUnitIncrement(10);
                this.sbrMinTemp.setBackground(new Color(225, 225, 225));
            } else {
                textSbrPanel.add(this.tfMaxTempF);
                textSbrPanel.add(this.sbrMaxTempF);
                this.sbrMaxTempF.setUnitIncrement(10);
                this.sbrMaxTempF.setBackground(new Color(225, 225, 225));
                textSbrPanel.add(this.tfMinTempF);
                textSbrPanel.add(this.sbrMinTempF);
                this.sbrMinTempF.setUnitIncrement(10);
                this.sbrMinTempF.setBackground(new Color(225, 225, 225));
            }
            upLeftPanel = new JPanel();
            upLeftPanel.setLayout(new FlowLayout());
            upLeftPanel.setBackground(currentColor);
            upLeftPanel.add(labelPanel);
            upLeftPanel.add(textSbrPanel);
            this.lThermalDif2.setForeground(Color.blue);
            this.lThermalDif2.setFont(new Font("Serif", 1, 10));
            this.lThermalDif2.setBounds(447, 9, 8, 20);
            this.add(this.lThermalDif2);
            labelPanel2 = new JPanel();
            labelPanel2.setLayout(new GridLayout(2, 1));
            labelPanel2.setBackground(currentColor);
            labelPanel2.add(this.lThermalDif);
            this.lThermalDif.setForeground(Color.blue);
            this.lThermalDif.setFont(new Font("Serif", 0, 14));
            labelPanel2.add(this.lTimeLag);
            this.lTimeLag.setForeground(Color.blue);
            this.lTimeLag.setFont(new Font("Serif", 0, 14));
            textSbrPanel2 = new JPanel();
            textSbrPanel2.setLayout(new GridLayout(2, 2, 5, 0));
            textSbrPanel2.setBackground(currentColor);
            textSbrPanel2.add(this.tfThermalDif);
            textSbrPanel2.add(this.sbrThermalDif);
            this.sbrThermalDif.setUnitIncrement(10);
            this.sbrThermalDif.setBackground(new Color(225, 225, 225));
            textSbrPanel2.add(this.tfTimeLag);
            textSbrPanel2.add(this.sbrTimeLag);
            this.sbrTimeLag.setBackground(new Color(225, 225, 225));
            upRightPanel = new JPanel();
            upRightPanel.setLayout(new FlowLayout());
            upRightPanel.setBackground(currentColor);
            upRightPanel.add(labelPanel2);
            upRightPanel.add(textSbrPanel2);
            topPanel = new JPanel();
            topPanel.setLayout(new FlowLayout());
            topPanel.setBackground(currentColor);
            topPanel.add(upLeftPanel);
            topPanel.add(upRightPanel);
            messagePanel = new JPanel();
            messagePanel.setLayout(null);
            messagePanel.setPreferredSize(new Dimension(640, 20));
            messagePanel.setBackground(currentColor);
            lMessage.setForeground(Color.red);
            lMessage.setFont(new Font("Serif", 0, 14));
            lMessage.setBounds(60, 0, 550, 20);
            messagePanel.add(lMessage);
            middlePanel = new JPanel();
            middlePanel.setLayout(null);
            middlePanel.setPreferredSize(new Dimension(640, 45));
            middlePanel.setBackground(currentColor);
            this.lDepth.setBounds(20, 0, 250, 20);
            this.lDepth.setForeground(Color.blue);
            this.lDepth.setFont(new Font("Serif", 0, 14));
            middlePanel.add(this.lDepth);
            this.lTime.setBounds(313, 0, 350, 20);
            this.lTime.setForeground(Color.blue);
            this.lTime.setFont(new Font("Serif", 0, 14));
            middlePanel.add(this.lTime);
            this.lDepth2.setBounds(30, 20, 120, 23);
            this.lDepth2.setForeground(Color.blue);
            this.lDepth2.setFont(new Font("Serif", 0, 14));
            middlePanel.add(this.lDepth2);
            this.tfDepth.setBounds(155, 20, 60, 23);
            middlePanel.add(this.tfDepth);
            this.sbrDepth.setBounds(220, 20, 60, 23);
            middlePanel.add(this.sbrDepth);
            this.sbrDepth.setUnitIncrement(100);
            this.sbrDepth.setBackground(new Color(225, 225, 225));
            this.lTime2.setForeground(Color.blue);
            this.lTime2.setFont(new Font("Serif", 0, 14));
            this.lTime2.setBounds(280, 20, 190, 23);
            middlePanel.add(this.lTime2);
            this.month.setBounds(467, 20, 95, 23);
            this.month.setFont(new Font("Serif", 0, 14));
            this.month.setBackground(Color.white);
            middlePanel.add(this.month);
            this.date.setBounds(562, 20, 50, 23);
            this.date.setFont(new Font("Serif", 0, 14));
            this.date.setBackground(Color.white);
            middlePanel.add(this.date);
            northPanel = new JPanel();
            northPanel.setBackground(currentColor);
            northPanel.setLayout(new BorderLayout());
            northPanel.add("North", topPanel);
            northPanel.add("Center", messagePanel);
            northPanel.add("South", middlePanel);
            buttonPanel = new JPanel();
            buttonPanel.setLayout(null);
            buttonPanel.setPreferredSize(new Dimension(640, 40));
            buttonPanel.setBackground(currentColor);
            bSave = new JButton("Retain Line");
            bSave.setFont(new Font("Serif", 0, 14));
            bSave.setForeground(Color.black);
            bSave.setBounds(230, 20, 97, 20);
            bSave.setBackground(currentColor);
            bClear = new JButton("Clear Line");
            bClear.setFont(new Font("Serif", 0, 14));
            bClear.setForeground(Color.black);
            bClear.setBounds(350, 20, 97, 20);
            bClear.setBackground(currentColor);
            buttonPanel.add(bSave);
            buttonPanel.add(bClear);
            graphPanel = new JPanel();
            graphPanel.setLayout(new BorderLayout());
            graphPanel.setBackground(currentColor);
            GraphCanvas graphCanvas = new GraphCanvas();
            GraphCanvas2 graphCanvas2 = new GraphCanvas2();
            int n = 300;
            int n2 = 255;
            graphPanel.add("North", buttonPanel);
            graphPanel.add("West", graphCanvas);
            graphPanel.add("East", graphCanvas2);
            this.setLayout(new BorderLayout());
            this.setBackground(currentColor);
            this.add("North", northPanel);
            this.add("South", graphPanel);
            this.sbrMaxTemp.addAdjustmentListener(new forEvent("MaxTemp"));
            this.sbrMinTemp.addAdjustmentListener(new forEvent("MinTemp"));
            this.sbrMaxTempF.addAdjustmentListener(new forEvent("MaxTempF"));
            this.sbrMinTempF.addAdjustmentListener(new forEvent("MinTempF"));
            this.sbrThermalDif.addAdjustmentListener(new forEvent("ThermalDif"));
            this.sbrTimeLag.addAdjustmentListener(new forEvent("TimeLag"));
            this.sbrDepth.addAdjustmentListener(new forEvent("Depth"));
            this.tfMaxTemp.addActionListener(new forEvent("MaxTemp"));
            this.tfMinTemp.addActionListener(new forEvent("MinTemp"));
            this.tfMaxTempF.addActionListener(new forEvent("MaxTempF"));
            this.tfMinTempF.addActionListener(new forEvent("MinTempF"));
            this.tfThermalDif.addActionListener(new forEvent("ThermalDif"));
            this.tfTimeLag.addActionListener(new forEvent("TimeLag"));
            this.tfDepth.addActionListener(new forEvent("Depth"));
            bSave.addMouseListener(new forEvent("Save"));
            bSave.addActionListener(new forEvent("SaveImage"));
            bClear.addMouseListener(new forEvent("Clear"));
            bClear.addActionListener(new forEvent("ClearImage"));
            this.tfMaxTemp.addFocusListener(new forEvent("MaxTemp"));
            this.tfMinTemp.addFocusListener(new forEvent("MinTemp"));
            this.tfMaxTempF.addFocusListener(new forEvent("MaxTempF"));
            this.tfMinTempF.addFocusListener(new forEvent("MinTempF"));
            this.tfThermalDif.addFocusListener(new forEvent("ThermalDif"));
            this.tfTimeLag.addFocusListener(new forEvent("TimeLag"));
            this.tfDepth.addFocusListener(new forEvent("Depth"));
            this.month.addItemListener(new forEvent("month"));
            this.date.addItemListener(new forEvent("date"));
            this.DefineIndependentVariables();
            graphCanvas.repaint();
            graphCanvas2.repaint();
        }

        private double TempVsTime(double d, TemperatureParameters temperatureParameters) {
            return temperatureParameters.avgTemp + temperatureParameters.amplitude * Math.exp(-temperatureParameters.depth / temperatureParameters.dampingDepth) * Math.sin(0.01721420632103996 * d - temperatureParameters.depth / temperatureParameters.dampingDepth - temperatureParameters.phaseConst);
        }

        private double TempVsDepth(double d, TemperatureParameters temperatureParameters) {
            return temperatureParameters.avgTemp + temperatureParameters.amplitude * Math.exp(-d / temperatureParameters.dampingDepth) * Math.sin(0.01721420632103996 * (double)temperatureParameters.dayOfInterest - d / temperatureParameters.dampingDepth - temperatureParameters.phaseConst);
        }

        private void DefineIndependentVariables() {
            this.x[0] = 0.0;
            this.y[0] = 0.0;
            double d = 365.0 / (double)maxpoints;
            double d2 = 20.0 / (double)maxpoints;
            this.j = 0;
            while (this.j < maxpoints + 1) {
                this.x[this.j] = (double)this.j * d;
                this.y[this.j] = (double)this.j * d2;
                ++this.j;
            }
        }

        private void CalculateTempVsTime(TemperatureParameters temperatureParameters) {
            for (int i = 0; i <= maxpoints; ++i) {
                this.tVt[i] = this.TempVsTime(this.x[i], temperatureParameters);
            }
        }

        private void CalculateTempVsTimeF(TemperatureParameters temperatureParameters) {
            for (int i = 0; i <= maxpoints; ++i) {
                this.tVt[i] = this.TempVsTime(this.x[i], temperatureParameters);
                this.tVtF[i] = 32.0 + 9.0 * this.tVt[i] / 5.0;
            }
        }

        private void CalculateTempVsDepth(TemperatureParameters temperatureParameters) {
            for (int i = 0; i <= maxpoints; ++i) {
                this.tVd[i] = this.TempVsDepth(this.y[i], temperatureParameters);
            }
        }

        private void CalculateTempVsDepthF(TemperatureParameters temperatureParameters) {
            for (int i = 0; i <= maxpoints; ++i) {
                this.tVd[i] = this.TempVsDepth(this.y[i], temperatureParameters);
                this.tVdF[i] = 32.0 + 9.0 * this.tVd[i] / 5.0;
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n != 0) {
                return 1;
            }
            this.paintComponent(graphics);
            return 0;
        }

        private void drawTicMarksOnX(double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
            double[] dArray = new double[2];
            int[] nArray = new int[2];
            if ((int)(d2 * 10.0) % 25 == 0) {
                this.xmax2 = d2;
            } else {
                for (int i = 2; i <= 11; ++i) {
                    if (!((double)(i * 5) > d2)) continue;
                    this.xmax2 = i * 5;
                    break;
                }
            }
            if ((int)(d * 10.0) % 25 == 0) {
                this.xmin2 = d;
            } else {
                for (int i = 7; i >= -7; --i) {
                    if (!((double)(i * 5) < d)) continue;
                    this.xmin2 = i * 5;
                    break;
                }
            }
            if (d2 == d) {
                this.xmax2 = 10.0;
                this.xmin2 = 5.0;
            }
            double d3 = (this.xmax2 - this.xmin2) / (double)n3;
            for (int i = 0; i <= n3; ++i) {
                dArray[0] = this.xmin2 + (double)i * d3;
                Tools.scaleX(dArray, this.xmin2, this.xmax2, 1, nArray, rectangle.width, rectangle.x, n, n2);
                graphics.drawLine(nArray[0], rectangle.y + rectangle.height, nArray[0], rectangle.y + rectangle.height - n6);
                graphics.drawLine(nArray[0], rectangle.y, nArray[0], rectangle.y + n6);
                String string = new String(Tools.formatDouble(dArray[0], n4, n5));
                graphics.drawString(string, nArray[0] - fontMetrics.stringWidth(string) / 2, rectangle.y - 10);
            }
        }

        private void drawTicMarksOnXF(double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
            double[] dArray = new double[2];
            int[] nArray = new int[2];
            if ((int)(d2 * 10.0) % 25 == 0) {
                this.xmax2 = d2;
            } else {
                for (int i = 9; i <= 25; ++i) {
                    if (!((double)(i * 5) > d2)) continue;
                    this.xmax2 = i * 5;
                    break;
                }
            }
            if ((int)(d * 10.0) % 25 == 0) {
                this.xmin2 = d;
            } else {
                for (int i = 20; i >= -5; --i) {
                    if (!((double)(i * 5) < d)) continue;
                    this.xmin2 = i * 5;
                    break;
                }
            }
            if (d2 == d) {
                this.xmax2 = 10.0;
                this.xmin2 = 5.0;
            }
            double d3 = (this.xmax2 - this.xmin2) / (double)n3;
            for (int i = 0; i <= n3; ++i) {
                dArray[0] = this.xmin2 + (double)i * d3;
                Tools.scaleX(dArray, this.xmin2, this.xmax2, 1, nArray, rectangle.width, rectangle.x, n, n2);
                graphics.drawLine(nArray[0], rectangle.y + rectangle.height, nArray[0], rectangle.y + rectangle.height - n6);
                graphics.drawLine(nArray[0], rectangle.y, nArray[0], rectangle.y + n6);
                String string = new String(Tools.formatDouble(dArray[0], n4, n5));
                graphics.drawString(string, nArray[0] - fontMetrics.stringWidth(string) / 2, rectangle.y - 10);
            }
        }

        private void drawTicMarksOnY(double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            int[] nArray = new int[2];
            double d3 = (d2 - d) / (double)n3;
            for (int i = 0; i <= n3; ++i) {
                dArray[0] = d + (double)i * d3;
                dArray2[0] = d2 - (double)i * d3;
                Tools.scaleY(dArray, d, d2, 1, nArray, rectangle.height, rectangle.y, n, n2);
                graphics.drawLine(rectangle.x, nArray[0], rectangle.x + n6, nArray[0]);
                graphics.drawLine(rectangle.x + rectangle.width, nArray[0], rectangle.x + rectangle.width - n6, nArray[0]);
                String string = new String(Tools.formatDouble(dArray2[0], n4, n5));
                graphics.drawString(string, rectangle.x - fontMetrics.stringWidth(string) - 3, nArray[0] + 4);
            }
        }

        private void drawTicMarksOnY2(double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
            double[] dArray = new double[2];
            int[] nArray = new int[2];
            if ((int)(d2 * 10.0) % 25 == 0) {
                this.ymax2 = d2;
            } else {
                for (int i = 2; i <= 11; ++i) {
                    if (!((double)(i * 5) > d2)) continue;
                    this.ymax2 = i * 5;
                    break;
                }
            }
            if ((int)(d * 10.0) % 25 == 0) {
                this.ymin2 = d;
            } else {
                for (int i = 7; i >= -7; --i) {
                    if (!((double)(i * 5) < d)) continue;
                    this.ymin2 = i * 5;
                    break;
                }
            }
            if (d2 == d) {
                this.ymax2 = 10.0;
                this.ymin2 = 5.0;
            }
            double d3 = (this.ymax2 - this.ymin2) / (double)n3;
            for (int i = 0; i <= n3; ++i) {
                dArray[0] = this.ymin2 + (double)i * d3;
                Tools.scaleY(dArray, this.ymin2, this.ymax2, 1, nArray, rectangle.height, rectangle.y, n, n2);
                graphics.drawLine(rectangle.x, nArray[0], rectangle.x + n6, nArray[0]);
                graphics.drawLine(rectangle.x + rectangle.width, nArray[0], rectangle.x + rectangle.width - n6, nArray[0]);
                String string = new String(Tools.formatDouble(dArray[0], n4, n5));
                graphics.drawString(string, rectangle.x - fontMetrics.stringWidth(string) - 3, nArray[0] + 4);
            }
        }

        private void drawTicMarksOnY2F(double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
            double[] dArray = new double[2];
            int[] nArray = new int[2];
            if ((int)(d2 * 10.0) % 25 == 0) {
                this.ymax2 = d2;
            } else {
                for (int i = 9; i <= 25; ++i) {
                    if (!((double)(i * 5) > d2)) continue;
                    this.ymax2 = i * 5;
                    break;
                }
            }
            if ((int)(d * 10.0) % 25 == 0) {
                this.ymin2 = d;
            } else {
                for (int i = 20; i >= -5; --i) {
                    if (!((double)(i * 5) < d)) continue;
                    this.ymin2 = i * 5;
                    break;
                }
            }
            if (d2 == d) {
                this.ymax2 = 10.0;
                this.ymin2 = 5.0;
            }
            double d3 = (this.ymax2 - this.ymin2) / (double)n3;
            for (int i = 0; i <= n3; ++i) {
                dArray[0] = this.ymin2 + (double)i * d3;
                Tools.scaleY(dArray, this.ymin2, this.ymax2, 1, nArray, rectangle.height, rectangle.y, n, n2);
                graphics.drawLine(rectangle.x, nArray[0], rectangle.x + n6, nArray[0]);
                graphics.drawLine(rectangle.x + rectangle.width, nArray[0], rectangle.x + rectangle.width - n6, nArray[0]);
                String string = new String(Tools.formatDouble(dArray[0], n4, n5));
                graphics.drawString(string, rectangle.x - fontMetrics.stringWidth(string) - 3, nArray[0] + 4);
            }
        }

        class IllegalValueException
        extends Exception {
            public IllegalValueException() {
            }

            public IllegalValueException(String string) {
                super(string);
            }
        }

        class forEvent
        implements AdjustmentListener,
        ActionListener,
        FocusListener,
        ItemListener,
        MouseListener {
            int iTemp;
            double dTemp;
            String sTemp;
            String name;

            public forEvent(String string) {
                this.name = string;
            }

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                lMessage.setText(" ");
                if (this.name.equals("MaxTemp")) {
                    this.iTemp = Temperature.this.sbrMaxTemp.getValue();
                    maxTemp = (double)this.iTemp / 10.0;
                    Temperature.this.tfMaxTemp.setText(Tools.formatDouble(maxTemp, 1, 1));
                } else if (this.name.equals("MinTemp")) {
                    this.iTemp = Temperature.this.sbrMinTemp.getValue();
                    minTemp = (double)this.iTemp / 10.0;
                    Temperature.this.tfMinTemp.setText(Tools.formatDouble(minTemp, 1, 1));
                } else if (this.name.equals("MaxTempF")) {
                    this.iTemp = Temperature.this.sbrMaxTempF.getValue();
                    maxTempF = (double)this.iTemp / 10.0;
                    Temperature.this.tfMaxTempF.setText(Tools.formatDouble(maxTempF, 1, 1));
                } else if (this.name.equals("MinTempF")) {
                    this.iTemp = Temperature.this.sbrMinTempF.getValue();
                    minTempF = (double)this.iTemp / 10.0;
                    Temperature.this.tfMinTempF.setText(Tools.formatDouble(minTempF, 1, 1));
                } else if (this.name.equals("ThermalDif")) {
                    this.iTemp = Temperature.this.sbrThermalDif.getValue();
                    thermalDif = (double)this.iTemp / 1000.0;
                    Temperature.this.tfThermalDif.setText(Tools.formatDouble(thermalDif, 4, 1));
                } else if (this.name.equals("TimeLag")) {
                    timeLag = this.iTemp = Temperature.this.sbrTimeLag.getValue();
                    Temperature.this.tfTimeLag.setText(Tools.formatDouble(timeLag, 0, 1));
                } else if (this.name.equals("Depth")) {
                    this.iTemp = Temperature.this.sbrDepth.getValue();
                    depth = (double)this.iTemp / 100.0;
                    Temperature.this.tfDepth.setText(Tools.formatDouble(depth, 2, 1));
                }
                this.performed();
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.name.equals("month")) {
                    month2 = Temperature.this.month.getSelectedIndex();
                    date2 = 1;
                    Temperature.this.date.removeAllItems();
                    for (int i = 0; i < Util.daysInMonth[month2]; ++i) {
                        Temperature.this.date.addItem("" + (i + 1));
                    }
                } else if (this.name.equals("date")) {
                    date2 = Temperature.this.date.getSelectedIndex() + 1;
                }
                this.performed();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.name.equals("SaveImage")) {
                    if (++jLines > 4) {
                        jLines = 0;
                    }
                } else if (this.name.equals("ClearImage")) {
                    for (int i = 0; i < 5; ++i) {
                        Temperature.this.params[i] = new TemperatureParameters();
                    }
                    jLines = 0;
                    this.performed();
                } else {
                    this.performed();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == bSave) {
                    bSave.setBorder(new BevelBorder(0));
                } else if (mouseEvent.getSource() == bClear) {
                    bClear.setBorder(new BevelBorder(0));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == bSave) {
                    bSave.setBorder(Temperature.this.etched);
                } else if (mouseEvent.getSource() == bClear) {
                    bClear.setBorder(Temperature.this.etched);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                this.performed();
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            private void performed() {
                try {
                    if (this.name.equals("MaxTemp")) {
                        this.sTemp = new String(Temperature.this.tfMaxTemp.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfMaxTemp.setText(Tools.formatDouble(this.dTemp, 1, 1));
                        if (this.dTemp < 5.0 || this.dTemp > 50.0) {
                            throw new IllegalValueException("Illegal Value:  The maximum temperature value must be between 5.0 and 50.0 deg C.");
                        }
                        Temperature.this.sbrMaxTemp.setValue((int)(this.dTemp * 10.0));
                        maxTemp = this.dTemp;
                        Temperature.this.tfMaxTemp.setText(Tools.formatDouble(this.dTemp, 1, 1));
                    } else if (this.name.equals("MinTemp")) {
                        this.sTemp = new String(Temperature.this.tfMinTemp.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfMinTemp.setText(Tools.formatDouble(this.dTemp, 1, 1));
                        if (this.dTemp < -30.0 || this.dTemp > 40.0) {
                            throw new IllegalValueException("Illegal Value:  The minimum temperature value must be between -30.0 and 40.0 deg C.");
                        }
                        Temperature.this.sbrMinTemp.setValue((int)(this.dTemp * 10.0));
                        minTemp = this.dTemp;
                        Temperature.this.tfMinTemp.setText(Tools.formatDouble(this.dTemp, 1, 1));
                    } else if (this.name.equals("MaxTempF")) {
                        this.sTemp = new String(Temperature.this.tfMaxTempF.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfMaxTempF.setText(Tools.formatDouble(this.dTemp, 1, 1));
                        if (this.dTemp < 41.0 || this.dTemp > 122.0) {
                            throw new IllegalValueException("Illegal Value:  The maximum temperature value must be between 41 and 122.");
                        }
                        Temperature.this.sbrMaxTempF.setValue((int)(this.dTemp * 10.0));
                        maxTempF = this.dTemp;
                        Temperature.this.tfMaxTempF.setText(Tools.formatDouble(this.dTemp, 1, 1));
                    } else if (this.name.equals("MinTempF")) {
                        this.sTemp = new String(Temperature.this.tfMinTempF.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfMinTempF.setText(Tools.formatDouble(this.dTemp, 1, 1));
                        if (this.dTemp < -22.0 || this.dTemp > 104.0) {
                            throw new IllegalValueException("Illegal Value:  The minimum temperature value must be between -22 and 104.");
                        }
                        Temperature.this.sbrMinTempF.setValue((int)(this.dTemp * 10.0));
                        minTempF = this.dTemp;
                        Temperature.this.tfMinTempF.setText(Tools.formatDouble(this.dTemp, 1, 1));
                    } else if (this.name.equals("ThermalDif")) {
                        this.sTemp = new String(Temperature.this.tfThermalDif.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfThermalDif.setText(Tools.formatDouble(this.dTemp, 4, 1));
                        if (this.dTemp < 0.001 || this.dTemp > 0.5) {
                            throw new IllegalValueException("Illegal Value:  The thermal diffusivity value must be between 0.001 and 0.5.");
                        }
                        Temperature.this.sbrThermalDif.setValue((int)(this.dTemp * 1000.0));
                        thermalDif = this.dTemp;
                        Temperature.this.tfThermalDif.setText(Tools.formatDouble(this.dTemp, 4, 1));
                    } else if (this.name.equals("TimeLag")) {
                        this.sTemp = new String(Temperature.this.tfTimeLag.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfTimeLag.setText(Tools.formatDouble(this.dTemp, 0, 1));
                        if (this.dTemp < 0.0 || this.dTemp > 365.0) {
                            throw new IllegalValueException("Illegal Value:  The time lag value must be between 0 and 365.");
                        }
                        Temperature.this.sbrTimeLag.setValue((int)this.dTemp);
                        timeLag = (int)this.dTemp;
                    } else if (this.name.equals("Depth")) {
                        this.sTemp = new String(Temperature.this.tfDepth.getText());
                        this.dTemp = new Double(this.sTemp);
                        Temperature.this.tfDepth.setText(Tools.formatDouble(this.dTemp, 2, 1));
                        if (this.dTemp < 0.0 || this.dTemp > 20.0) {
                            throw new IllegalValueException("Illegal Value:  The depth for the Temp Vs Time graph must be between 0.00 and 20.00.");
                        }
                        Temperature.this.sbrDepth.setValue((int)(this.dTemp * 100.0));
                        depth = this.dTemp;
                        Temperature.this.tfDepth.setText(Tools.formatDouble(this.dTemp, 2, 1));
                    }
                    if (maxTemp <= minTemp || maxTempF <= minTempF) {
                        throw new IllegalValueException("Illegal Value:  The maximum temperature value must be greater than minimum temperature.");
                    }
                    if (celsiusUnits) {
                        Temperature.this.params[SoilTemperature.jLines] = new TemperatureParameters(maxTemp, minTemp, thermalDif, timeLag, depth, month2, date2);
                    } else {
                        maxTemp = (maxTempF - 32.0) * 5.0 / 9.0;
                        minTemp = (minTempF - 32.0) * 5.0 / 9.0;
                        Temperature.this.params[SoilTemperature.jLines] = new TemperatureParameters(maxTemp, minTemp, thermalDif, timeLag, depth, month2, date2);
                    }
                    SoilTemperature.updateMessage();
                    Temperature.this.repaint();
                }
                catch (Exception exception) {
                    if (exception instanceof IllegalValueException) {
                        lMessage.setText(exception.getMessage());
                    }
                    lMessage.setText("Error in number format");
                }
            }
        }

        class GraphCanvas2
        extends JPanel {
            double maxT;
            double minT;
            double maxTF;
            double minTF;

            public GraphCanvas2() {
                this.setPreferredSize(new Dimension(300, 255));
            }

            public void paint(Graphics graphics) {
                int n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics.setColor(Color.red);
                graphics.setFont(new Font("Serif", 0, 14));
                Rectangle rectangle = this.getBounds();
                rectangle.x = 55;
                rectangle.y = 40;
                rectangle.width = Temperature.this.gW - rectangle.x - 25;
                rectangle.height = Temperature.this.gH - rectangle.y - 40;
                Temperature.this.fm = this.getFontMetrics(this.getFont());
                Tools.drawBorder(rectangle, 2, graphics);
                this.maxT = -50.0;
                this.minT = 50.0;
                for (n = 0; n < 5; ++n) {
                    if (Temperature.this.params[n].dayOfInterest < 0) continue;
                    if (Temperature.this.params[n].maxTemp > this.maxT) {
                        this.maxT = Temperature.this.params[n].maxTemp;
                    }
                    if (!(Temperature.this.params[n].minTemp < this.minT)) continue;
                    this.minT = Temperature.this.params[n].minTemp;
                }
                if (celsiusUnits) {
                    Temperature.this.drawTicMarksOnX(this.minT, this.maxT, 10, 10, 5, 1, 2, 8, Temperature.this.fm, rectangle, graphics);
                } else {
                    this.minTF = 9.0 * this.minT / 5.0 + 32.0;
                    this.maxTF = 9.0 * this.maxT / 5.0 + 32.0;
                    Temperature.this.drawTicMarksOnXF(this.minTF, this.maxTF, 10, 10, 5, 1, 2, 8, Temperature.this.fm, rectangle, graphics);
                }
                Temperature.this.drawTicMarksOnY(0.0, 20.0, 0, 0, 5, 0, 2, 8, Temperature.this.fm, rectangle, graphics);
                graphics2D.translate(rectangle.x - 30, rectangle.y + 100);
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.drawString("Depth (m)", 0, 0);
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(-(rectangle.x - 30), -(rectangle.y + 100));
                if (celsiusUnits) {
                    graphics.drawString("Temperature (\u00b0C)", rectangle.x + 68, rectangle.y - 27);
                } else {
                    graphics.drawString("Temperature (\u00b0F)", rectangle.x + 68, rectangle.y - 27);
                }
                for (n = 4; n >= 0; --n) {
                    if (Temperature.this.params[n].dayOfInterest < 0) continue;
                    if (celsiusUnits) {
                        Temperature.this.CalculateTempVsDepth(Temperature.this.params[n]);
                    } else {
                        Temperature.this.CalculateTempVsDepthF(Temperature.this.params[n]);
                    }
                    graphics.setColor(colorLine[n]);
                    if (celsiusUnits) {
                        Tools.plotXY(maxpoints, Temperature.this.tVd, Temperature.this.y, Temperature.this.xmin2, Temperature.this.xmax2, 20.0, 0.0, 10, 10, 0, 0, rectangle, graphics);
                        continue;
                    }
                    Tools.plotXY(maxpoints, Temperature.this.tVdF, Temperature.this.y, Temperature.this.xmin2, Temperature.this.xmax2, 20.0, 0.0, 10, 10, 0, 0, rectangle, graphics);
                }
            }
        }

        class GraphCanvas
        extends JPanel {
            double maxT;
            double minT;
            double maxTF;
            double minTF;

            public GraphCanvas() {
                this.setPreferredSize(new Dimension(300, 255));
            }

            public void paint(Graphics graphics) {
                int n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics.setColor(Color.red);
                graphics.setFont(new Font("Serif", 0, 14));
                Rectangle rectangle = this.getBounds();
                rectangle.x = 55;
                rectangle.y = 20;
                rectangle.width = Temperature.this.gW - rectangle.x - 25;
                rectangle.height = Temperature.this.gH - rectangle.y - 50;
                Temperature.this.fm = this.getFontMetrics(this.getFont());
                Tools.drawBorder(rectangle, 2, graphics);
                this.maxT = -50.0;
                this.minT = 50.0;
                for (n = 0; n < 5; ++n) {
                    if (Temperature.this.params[n].dayOfInterest < 0) continue;
                    if (Temperature.this.params[n].maxTemp > this.maxT) {
                        this.maxT = Temperature.this.params[n].maxTemp;
                    }
                    if (!(Temperature.this.params[n].minTemp < this.minT)) continue;
                    this.minT = Temperature.this.params[n].minTemp;
                }
                Tools.drawTicMarksOnX(0.0, 365.0, 0, 0, 5, 0, 2, 8, Temperature.this.fm, rectangle, graphics);
                if (celsiusUnits) {
                    Temperature.this.drawTicMarksOnY2(this.minT, this.maxT, 10, 10, 5, 1, 2, 8, Temperature.this.fm, rectangle, graphics);
                } else {
                    this.minTF = 9.0 * this.minT / 5.0 + 32.0;
                    this.maxTF = 9.0 * this.maxT / 5.0 + 32.0;
                    Temperature.this.drawTicMarksOnY2F(this.minTF, this.maxTF, 10, 10, 5, 1, 2, 8, Temperature.this.fm, rectangle, graphics);
                }
                graphics.drawString("Time (day of year)", rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height + 35);
                graphics2D.translate(rectangle.x - 40, rectangle.y + 130);
                graphics2D.rotate(-1.5707963267948966);
                if (celsiusUnits) {
                    graphics2D.drawString("Temperature (\u00b0C)", 0, 0);
                } else {
                    graphics2D.drawString("Temperature (\u00b0F)", 0, 0);
                }
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(-(rectangle.x - 40), -(rectangle.y + 130));
                for (n = 4; n >= 0; --n) {
                    if (Temperature.this.params[n].dayOfInterest < 0) continue;
                    if (celsiusUnits) {
                        Temperature.this.CalculateTempVsTime(Temperature.this.params[n]);
                    } else {
                        Temperature.this.CalculateTempVsTimeF(Temperature.this.params[n]);
                    }
                    graphics.setColor(colorLine[n]);
                    if (celsiusUnits) {
                        Tools.plotXY(maxpoints, Temperature.this.x, Temperature.this.tVt, 0.0, 365.0, Temperature.this.ymin2, Temperature.this.ymax2, 0, 0, 10, 10, rectangle, graphics);
                        continue;
                    }
                    Tools.plotXY(maxpoints, Temperature.this.x, Temperature.this.tVtF, 0.0, 365.0, Temperature.this.ymin2, Temperature.this.ymax2, 0, 0, 10, 10, rectangle, graphics);
                }
            }
        }
    }

    static class forPrinting
    extends JFrame {
        private PageFormat mPageFormat;

        public forPrinting() {
            super("Soil Temperature");
            this.createUI();
            this.setVisible(true);
            this.setResizable(false);
        }

        protected void createUI() {
            this.setSize(640, 540);
            this.center();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File", true);
            jMenu.add(new FilePageSetupAction());
            jMenu.add(new screenPrintAction());
            jMenu.add(new screenSaveAction());
            JMenu jMenu2 = new JMenu("Preferences", true);
            jMenu2.add(new bgColorAction());
            JMenu jMenu3 = new JMenu("Select temperature unit");
            jMenu2.add(jMenu3);
            JRadioButton jRadioButton = new JRadioButton("Celsius", true);
            JRadioButton jRadioButton2 = new JRadioButton("Fahrenheit", false);
            buttonGroupMenu.add(jRadioButton);
            buttonGroupMenu.add(jRadioButton2);
            jMenu3.add(jRadioButton);
            jMenu3.add(jRadioButton2);
            jRadioButton.addItemListener(new temperatureAction("Celsius"));
            jRadioButton2.addItemListener(new temperatureAction("Fahrenheit"));
            JMenu jMenu4 = new JMenu("Help", true);
            jMenu4.add(new docAction());
            jMenu4.add(new dialogAction());
            jMenu.addSeparator();
            jMenu.add(new FileQuitAction());
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu4);
            this.setJMenuBar(jMenuBar);
            mainPanel = new Temperature();
            this.getContentPane().add(mainPanel);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ forPrinting this$0;
                {
                    this.this$0 = forPrinting2;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }

        protected void center() {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            this.setLocation(n, n2);
        }

        class FileQuitAction
        extends AbstractAction {
            public FileQuitAction() {
                super("Exit");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        }

        class ColorSelectDialog
        extends JDialog {
            protected JColorChooser chooser;
            protected JButton okButton;
            protected JButton cancelButton;

            public ColorSelectDialog(Frame frame, ActionListener actionListener) {
                super(frame, "Choose a  background color...", true);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setBorder(BorderFactory.createEtchedBorder());
                this.chooser = new JColorChooser();
                jPanel.add((Component)this.chooser, "Center");
                this.okButton = new JButton("    OK    ");
                this.okButton.setBorder(new BevelBorder(0));
                this.cancelButton = new JButton("Cancel");
                this.cancelButton.setBorder(new BevelBorder(0));
                this.okButton.addActionListener(actionListener);
                this.cancelButton.addActionListener(actionListener);
                JPanel jPanel2 = new JPanel();
                jPanel2.add(this.okButton);
                jPanel2.add(this.cancelButton);
                jPanel.add((Component)jPanel2, "South");
                this.getContentPane().add(jPanel);
                this.pack();
            }

            public void setValue(Color color) {
                this.chooser.setColor(color);
            }

            public Color getValue() {
                return this.chooser.getColor();
            }
        }

        class bgColorAction
        extends AbstractAction
        implements Runnable {
            protected ColorSelectDialog dialog;
            protected boolean showingDialog;
            public boolean canceled;

            public bgColorAction() {
                super("Change background color");
                this.createDialog();
            }

            protected void createDialog() {
                if (this.dialog == null) {
                    this.dialog = new ColorSelectDialog(new Frame("Dummy"), this);
                    this.dialog.addWindowListener(new WindowAdapter(this){
                        private final /* synthetic */ bgColorAction this$1;
                        {
                            this.this$1 = bgColorAction2;
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            JDialog jDialog = (JDialog)windowEvent.getSource();
                            this.this$1.canceled = true;
                            this.this$1.showDialog();
                        }
                    });
                }
            }

            protected void showDialog() {
                if (!this.showingDialog) {
                    Thread thread = new Thread(this);
                    this.showingDialog = true;
                    thread.start();
                }
            }

            protected void dismissDialog() {
                if (this.showingDialog) {
                    this.dialog.hide();
                    this.showingDialog = false;
                }
            }

            public void run() {
                this.dialog.setValue(currentColor);
                this.canceled = false;
                this.dialog.show();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    this.showDialog();
                    JButton jButton = (JButton)actionEvent.getSource();
                    if (jButton.getActionCommand() == "    OK    ") {
                        currentColor = this.dialog.getValue();
                        this.canceled = false;
                    } else {
                        this.canceled = true;
                    }
                    labelPanel.setBackground(currentColor);
                    labelPanel.repaint();
                    labelPanel2.setBackground(currentColor);
                    labelPanel2.repaint();
                    upLeftPanel.setBackground(currentColor);
                    upLeftPanel.repaint();
                    upRightPanel.setBackground(currentColor);
                    upRightPanel.repaint();
                    mainPanel.setBackground(currentColor);
                    mainPanel.repaint();
                    northPanel.setBackground(currentColor);
                    northPanel.repaint();
                    messagePanel.setBackground(currentColor);
                    messagePanel.repaint();
                    middlePanel.setBackground(currentColor);
                    middlePanel.repaint();
                    graphPanel.setBackground(currentColor);
                    graphPanel.repaint();
                    textSbrPanel.setBackground(currentColor);
                    textSbrPanel.repaint();
                    textSbrPanel2.setBackground(currentColor);
                    textSbrPanel2.repaint();
                    topPanel.setBackground(currentColor);
                    topPanel.repaint();
                    buttonPanel.setBackground(currentColor);
                    buttonPanel.repaint();
                    bSave.setBackground(currentColor);
                    bSave.repaint();
                    bClear.setBackground(currentColor);
                    bClear.repaint();
                    this.dismissDialog();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class dialogAction
        extends AbstractAction {
            public dialogAction() {
                super("About...");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(forPrinting.this.getContentPane(), "SoilTemperature\n    Version 2003.08.19\n    Copyright \u00a9 2002\n    Oklahoma Agricultural Experiment Station\n    Oklahoma State University\n    Stillwater, Oklahoma\n\nAuthors:\n    D. L. Nofziger and Jinquan Wu\nProgrammers:\n    D. L. Nofziger, Xinhua Wang, and Jinquan Wu\n\nContact:\n    D. L. Nofziger, Professor\n    Department of Plant and Soil Sciences\n    Oklahoma State University\n    Stillwater, OK 74078\n    E-mail: dln@okstate.edu", "About SoilTemperature", 1);
            }
        }

        class temperatureAction
        implements ItemListener {
            String name;

            public temperatureAction(String string) {
                this.name = string;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.name.equals("Celsius")) {
                    celsiusUnits = true;
                    forPrinting.this.getContentPane().removeAll();
                    Temperature temperature = new Temperature();
                    forPrinting.this.getContentPane().add(temperature);
                } else if (this.name.equals("Fahrenheit")) {
                    celsiusUnits = false;
                    maxTempF = 32.0 + maxTemp * 9.0 / 5.0;
                    minTempF = 32.0 + minTemp * 9.0 / 5.0;
                    forPrinting.this.getContentPane().removeAll();
                    Temperature temperature = new Temperature();
                    forPrinting.this.getContentPane().add(temperature);
                }
                SoilTemperature.updateMessage();
                if (celsiusUnits) {
                    SoilTemperature.params[SoilTemperature.jLines] = new TemperatureParameters(maxTemp, minTemp, thermalDif, timeLag, depth, month2, date2);
                } else {
                    maxTemp = (maxTempF - 32.0) * 5.0 / 9.0;
                    minTemp = (minTempF - 32.0) * 5.0 / 9.0;
                    SoilTemperature.params[SoilTemperature.jLines] = new TemperatureParameters(maxTemp, minTemp, thermalDif, timeLag, depth, month2, date2);
                }
                forPrinting.this.repaint();
            }
        }

        class docAction
        extends AbstractAction {
            public docAction() {
                super("Documentation");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = null;
                try {
                    uRL = new URL("http://soilphysics.okstate.edu/software/SoilTemperature/document.html");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    BasicService basicService = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
                    basicService.showDocument(uRL);
                }
                catch (UnavailableServiceException unavailableServiceException) {
                    // empty catch block
                }
            }
        }

        class screenSaveAction
        extends AbstractAction {
            public screenSaveAction() {
                super("Save screen");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FileSaveService fileSaveService;
                try {
                    fileSaveService = (FileSaveService)ServiceManager.lookup("javax.jnlp.FileSaveService");
                }
                catch (UnavailableServiceException unavailableServiceException) {
                    fileSaveService = null;
                }
                if (fileSaveService != null) {
                    try {
                        FileContents fileContents = fileSaveService.saveFileDialog(null, null, new ByteArrayInputStream(new byte[1000]), null);
                        fileContents.setMaxLength(80000L);
                        Dimension dimension = mainPanel.getSize();
                        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.setPaint(mainPanel.getBackground());
                        Dimension dimension2 = mainPanel.getSize();
                        graphics2D.fillRect(0, 0, dimension2.width, dimension2.height);
                        graphics2D.setPaint(mainPanel.getForeground());
                        mainPanel.paint(graphics2D);
                        OutputStream outputStream = fileContents.getOutputStream(true);
                        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
                        jPEGImageEncoder.encode(bufferedImage);
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        class screenPrintAction
        extends AbstractAction {
            public screenPrintAction() {
                super("Print Screen");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PrintService printService;
                try {
                    printService = (PrintService)ServiceManager.lookup("javax.jnlp.PrintService");
                }
                catch (UnavailableServiceException unavailableServiceException) {
                    printService = null;
                }
                if (printService != null) {
                    try {
                        forPrinting.this.mPageFormat = printService.getDefaultPage();
                        ComponentPrintable componentPrintable = new ComponentPrintable(forPrinting.this.getContentPane());
                        printService.print(componentPrintable);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        class FilePageSetupAction
        extends AbstractAction {
            public FilePageSetupAction() {
                super("Page Setup...");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PrintService printService;
                try {
                    printService = (PrintService)ServiceManager.lookup("javax.jnlp.PrintService");
                }
                catch (UnavailableServiceException unavailableServiceException) {
                    printService = null;
                }
                if (printService != null) {
                    try {
                        forPrinting.this.mPageFormat = printService.getDefaultPage();
                        PageFormat pageFormat = printService.showPageFormatDialog(forPrinting.this.mPageFormat);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }
}

